<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<!-- Debug Mode Active -->\n";

try {
    require_once __DIR__ . '/config/config.php';
    require_once __DIR__ . '/includes/functions.php';
    
    $error = '';
    $success = '';
    $step = 'mobile';
    
    // Redirect if already logged in
    if (isLoggedIn()) {
        header('Location: /dashboard.php');
        exit;
    }
    
    // مرحله 1: ارسال کد OTP
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['send_otp'])) {
        echo "<!-- POST received: send_otp -->\n";
        
        $mobile = sanitize($_POST['mobile'] ?? '');
        echo "<!-- Mobile: $mobile -->\n";
        
        if (empty($mobile)) {
            $error = 'لطفاً شماره موبایل را وارد کنید.';
        } elseif (!validateMobile($mobile)) {
            $error = 'شماره موبایل نامعتبر است.';
        } else {
            echo "<!-- Checking user existence -->\n";
            $userExists = getUserByMobile($mobile) !== null;
            echo "<!-- User exists: " . ($userExists ? "yes" : "no") . " -->\n";
            
            if (!$userExists) {
                $error = 'کاربری با این شماره موبایل یافت نشد. لطفاً ابتدا <a href="/register.php" style="color: #667eea; text-decoration: underline;">ثبت‌نام</a> کنید.';
            } else {
                echo "<!-- Creating and sending OTP -->\n";
                try {
                    $result = createAndSendOTP($mobile, 'login');
                    echo "<!-- OTP Result: " . json_encode($result) . " -->\n";
                    
                    if ($result['success']) {
                        $_SESSION['otp_mobile'] = $mobile;
                        $_SESSION['otp_type'] = 'login';
                        $success = $result['message'];
                        $step = 'otp';
                    } else {
                        $error = $result['message'];
                    }
                } catch (Exception $e) {
                    $error = 'خطا در ارسال کد: ' . $e->getMessage();
                    echo "<!-- Exception: " . $e->getMessage() . " -->\n";
                }
            }
        }
    }
    
    // مرحله 2: بررسی کد OTP
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['verify_otp'])) {
        echo "<!-- POST received: verify_otp -->\n";
        
        $mobile = $_SESSION['otp_mobile'] ?? '';
        $code = sanitize($_POST['otp_code'] ?? '');
        
        if (empty($code)) {
            $error = 'لطفاً کد تایید را وارد کنید.';
            $step = 'otp';
        } else {
            echo "<!-- Verifying OTP -->\n";
            try {
                $result = loginWithOTP($mobile, $code);
                echo "<!-- Login Result: " . json_encode($result) . " -->\n";
                
                if ($result['success']) {
                    unset($_SESSION['otp_mobile']);
                    unset($_SESSION['otp_type']);
                    
                    $redirect = $_GET['redirect'] ?? '/dashboard.php';
                    header('Location: ' . $redirect);
                    exit;
                } else {
                    $error = $result['message'];
                    $step = 'otp';
                }
            } catch (Exception $e) {
                $error = 'خطا در تایید کد: ' . $e->getMessage();
                echo "<!-- Exception: " . $e->getMessage() . " -->\n";
            }
        }
    }
    
    // ارسال مجدد کد
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['resend_otp'])) {
        echo "<!-- POST received: resend_otp -->\n";
        
        $mobile = $_SESSION['otp_mobile'] ?? '';
        
        if (!empty($mobile)) {
            try {
                $result = createAndSendOTP($mobile, 'login');
                
                if ($result['success']) {
                    $success = 'کد تایید مجدداً ارسال شد.';
                    $step = 'otp';
                } else {
                    $error = $result['message'];
                    $step = 'otp';
                }
            } catch (Exception $e) {
                $error = 'خطا در ارسال مجدد: ' . $e->getMessage();
                echo "<!-- Exception: " . $e->getMessage() . " -->\n";
            }
        }
    }
    
    // تنظیم step بر اساس session
    if (isset($_SESSION['otp_mobile']) && !isset($_POST['send_otp'])) {
        $step = 'otp';
    }
    
    echo "<!-- Current step: $step -->\n";
    echo "<!-- Error: $error -->\n";
    echo "<!-- Success: $success -->\n";
    
} catch (Exception $e) {
    echo "<h1 style='color: red;'>Fatal Error</h1>";
    echo "<p>" . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
    exit;
}

$pageTitle = 'ورود (Debug)';
include __DIR__ . '/includes/header.php';
?>

<style>
.auth-container {
    max-width: 500px;
    margin: 3rem auto;
    padding: 0 1rem;
}

.auth-box {
    background: white;
    border-radius: 20px;
    padding: 2.5rem;
    box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
}

.auth-header {
    text-align: center;
    margin-bottom: 2rem;
}

.auth-header h2 {
    color: #2c3e50;
    margin-bottom: 0.5rem;
}

.auth-header p {
    color: #7f8c8d;
    font-size: 0.95rem;
}

.alert {
    padding: 15px;
    border-radius: 10px;
    margin-bottom: 20px;
}

.alert-error {
    background: #fee;
    color: #c33;
    border: 1px solid #fcc;
}

.alert-success {
    background: #efe;
    color: #3c3;
    border: 1px solid #cfc;
}

.form-group {
    margin-bottom: 20px;
}

.form-group label {
    display: block;
    margin-bottom: 8px;
    font-weight: 600;
    color: #333;
}

.form-group input {
    width: 100%;
    padding: 15px;
    border: 2px solid #e0e0e0;
    border-radius: 10px;
    font-size: 1rem;
    box-sizing: border-box;
    font-family: 'Vazirmatn', Arial, sans-serif;
}

.btn {
    padding: 15px 30px;
    border: none;
    border-radius: 10px;
    font-size: 1.1rem;
    font-weight: 600;
    cursor: pointer;
    width: 100%;
    font-family: 'Vazirmatn', Arial, sans-serif;
}

.btn-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}
</style>

<div class="auth-container">
    <div class="auth-box">
        <div style="background: #fff3cd; padding: 10px; border-radius: 5px; margin-bottom: 20px; text-align: center;">
            🐛 Debug Mode - Errors will be displayed
        </div>
        
        <?php if ($error): ?>
        <div class="alert alert-error">
            ❌ <?php echo $error; ?>
        </div>
        <?php endif; ?>

        <?php if ($success): ?>
        <div class="alert alert-success">
            ✅ <?php echo $success; ?>
        </div>
        <?php endif; ?>

        <?php if ($step == 'mobile'): ?>
        <div class="auth-header">
            <h2>ورود به حساب کاربری</h2>
            <p>شماره موبایل خود را وارد کنید</p>
        </div>

        <form method="POST" class="auth-form">
            <div class="form-group">
                <label>شماره موبایل</label>
                <input type="text" name="mobile" placeholder="۰۹۱۲۳۴۵۶۷۸۹" required 
                       value="<?php echo htmlspecialchars($_POST['mobile'] ?? ''); ?>"
                       style="text-align: center; font-size: 1.2rem;"
                       autofocus>
            </div>

            <button type="submit" name="send_otp" class="btn btn-primary">
                ارسال کد تایید
            </button>
        </form>

        <?php else: ?>
        <div class="auth-header">
            <h2>کد تایید</h2>
            <p>کد 6 رقمی ارسال شده به <strong><?php echo $_SESSION['otp_mobile']; ?></strong> را وارد کنید</p>
        </div>

        <form method="POST" class="auth-form">
            <div class="form-group">
                <label>کد تایید</label>
                <input type="text" name="otp_code" placeholder="۱۲۳۴۵۶" required 
                       maxlength="6"
                       style="text-align: center; font-size: 1.8rem; letter-spacing: 0.5rem;"
                       autofocus>
            </div>

            <button type="submit" name="verify_otp" class="btn btn-primary">
                تایید و ورود
            </button>
        </form>

        <div style="text-align: center; margin-top: 1.5rem;">
            <form method="POST" style="display: inline;">
                <button type="submit" name="resend_otp" style="background: none; border: none; color: #667eea; cursor: pointer; text-decoration: underline;">
                    ارسال مجدد کد
                </button>
            </form>
        </div>
        <?php endif; ?>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>

